PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144770162"
 Author = "jayas.jayas"
 Desc = "Parallel Transmission Line"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = "Case3.snp"
  OFile = "noname.out"
  SFile = "Case3.snp"
  SnapTime = 0.2
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144770087
  Nodes = 
   {
   Output("F",36,18)
    {
    Type = Integer
    }
   Output("B",36,-36)
    {
    Type = Integer
    Dim  = [4]
    }
   Input("Flt_en",36,-18)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Line(34,-18,27,-18)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   -Sticky-([72,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,666,180,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   0.export([1530,1116],4,0,300)
    {
    Name = "F"
    }
   -Wire-([648,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([684,684],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([684,720],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([810,702],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1440,1116],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1440,1116],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(41078392)
    Meter(41106560)
    Slider(41075536)
    Meter(41023160)
    Meter(41128528)
    Meter(40898680)
    Meter(41122512)
    Meter(41006040)
    }
   -Sticky-([522,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 522,108,684,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.arrow_a([522,216],1,0,-1)
    {
    }
   -ControlPanel-([72,720],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(41034088)
    Dial(41061696)
    Slider(40266928)
    Slider(40269784)
    Slider(41132808)
    }
   0.datalabel([1548,720],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([1548,774],3,0,-1)
    {
    Name = "B3T2"
    }
   0.datalabel([1548,828],3,0,-1)
    {
    Name = "B4T1"
    }
   0.datalabel([1440,972],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1440,990],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1440,1008],6,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1440,1026],6,0,-1)
    {
    Name = "B4"
    }
   0.datamerge([1458,1044],4,0,290)
    {
    N = "4"
    Type = "1"
    Disp = "1"
    }
   0.export([1494,1062],4,0,310)
    {
    Name = "B"
    }
   -Wire-([648,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -ControlPanel-([1278,252],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(40219344)
    Slider(40238352)
    Slider(40231712)
    }
   -ControlPanel-([1278,396],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(40223312)
    Slider(40234432)
    Slider(40257912)
    }
   0.datalabel([1548,882],3,0,-1)
    {
    Name = "B4T2"
    }
   -ControlPanel-([1278,630],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(40245160)
    Slider(40251064)
    Slider(40177160)
    }
   -ControlPanel-([1278,774],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(40253536)
    Slider(40174304)
    Slider(40171152)
    }
   0.var([1512,882],0,40171152,170)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1512,828],0,40174304,150)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.34"
    Units = "s"
    Collect = "1"
    }
   0.var([1512,774],0,40177160,140)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.tfaultn([774,702],4,0,240)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Sticky-([18,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,198,144,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(41072680)
    Meter(41100648)
    Slider(41069824)
    Meter(41021016)
    Meter(41029144)
    Meter(40901648)
    Meter(41066912)
    Meter(41003128)
    }
   -Wire-([1782,504],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1782,324],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1782,360],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([1818,324],0,0,210)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1854,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1854,288],0,40219344,10)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.datalabel([1962,324],4,0,-1)
    {
    Name = "B1"
    }
   -Wire-([1854,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1854,450],6,40223312,60)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1890,468],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([1962,468],2,0,-1)
    {
    Name = "B2"
    }
   0.tbreakn([1728,324],4,0,200)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.tbreakn([1728,504],4,0,80)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   0.datalabel([1548,342],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([1548,396],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1548,450],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([1512,396],0,40231712,30)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1512,450],0,40234432,50)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1548,504],3,0,-1)
    {
    Name = "B2T2"
    }
   0.var([1512,342],0,40238352,20)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.logic([1926,324],6,0,220)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([1782,882],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1782,702],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.logic([1818,882],6,0,190)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1746,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.logic([1818,702],0,0,260)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1854,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1854,666],0,40245160,120)
    {
    Name = "42-B3"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1854,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1890,846],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([1962,702],4,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1962,846],2,0,-1)
    {
    Name = "B4"
    }
   0.var([1512,720],0,40251064,130)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.28"
    Units = "s"
    Collect = "1"
    }
   0.var_switch([1854,828],6,40253536,160)
    {
    Name = "42-B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.logic([1926,846],0,0,280)
    {
    Type = "2"
    Inv = "0"
    }
   0.tbreakn([1728,882],4,0,180)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   0.var([1512,504],0,40257912,70)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.tbreakn([1728,702],4,0,250)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   0.logic([1926,468],0,0,230)
    {
    Type = "2"
    Inv = "0"
    }
   0.import([1620,414],0,0,40)
    {
    Name = "Flt_en"
    }
   -Wire-([1782,738],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([1656,792],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([1656,414],0,0,-1)
    {
    Vertex="0,0;0,378"
    }
   0.logic([1818,504],6,0,90)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([1926,702],6,0,270)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([1656,414],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.var([612,684],0,40266928,100)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   0.var([612,720],0,40269784,110)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = ""
    Collect = "1"
    }
   -Sticky-([252,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 252,864,396,1080
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> No Fault (0)
11=> No fault (0)"
    }
   -Sticky-([72,864],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,864,234,1170
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source
          and  B1
  2=> FT2: 
          Between B1 
          and Line
  3=> FT3: 
          Between Line 1
          and B2
  4=> FT4: 
          Between Source
          and B2
  5=> FT5:
          Between B3
          and Line 2
  6=> FT6:
          Between Line 2 
          and B4  "
    }
   -Sticky-([900,612],0)
    {
    Name = ""
    Font = 1
    Bounds = 900,612,1170,936
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Example of a Test  Sequence

Fault is located on Line 2 at B3 (Fault location 5)
Fault is AB to Ground (Fault Type 4)

Fault occurs at  0.20 sec, Fault Duration 0.05 sec

Set Breakers:
B1T1 =  2.00:  Breaker B1 does not trip
B2T1 =  2.00:  Breaker B1 does not trip
B3T1 =  0.35:  Breaker B3 trips in 35 msec
B4T1 =  0.40:  Breaker B4 trips in 40 msec
B1T2 =  2.00:  Breaker B1 does not reclose
B2T2 =  2.00:  Breaker B1 does not reclose
B3T2 =  2.00:  Breaker B3 does not reclose
B4T2 =  2.00:  Breaker B4 does not reclose

(Breaker  B1  and B2  do not automatically operate)
"
    }
   -Sticky-([1278,162],0)
    {
    Name = ""
    Font = 1
    Bounds = 1278,162,1386,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Sticky-([1422,162],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1422,162,1584,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   -Sticky-([1278,954],0)
    {
    Name = ""
    Font = 1
    Bounds = 1278,954,1386,990
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -Sticky-([936,126],0)
    {
    Name = ""
    Font = 1
    Bounds = 936,126,1044,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback  Recorders"
    }
   -ControlPanel-([936,180],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(41140592)
    Slider(40788112)
    }
   -ControlPanel-([864,324],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,288,126
    Switch(41149808)
    Switch(41152528)
    Switch(41155248)
    Switch(41157968)
    }
   -Sticky-([882,468],0)
    {
    Name = ""
    Font = 1
    Bounds = 882,468,1134,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, click on the switch.
On = Recorder will record data.
Off = Recorder will NOT record data.

You can turn on or off each recorder individually."
    }
   -Divider-([1206,90],0)
    {
    Size(0,1476)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([18,594],0)
    {
    Size(1188,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 1
    }
   -Divider-([1206,936],0)
    {
    Size(1152,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([756,108],0)
    {
    Size(0,486)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots")
  {
  Desc = ""
  FileDate = 1144770087
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   -Plot-([1242,36],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,558,1476]
    Posn = [1242,36]
    Icon = [-1,-1]
    Extents = 0,0,558,1476
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,558,358],"Voltage")
     {
     Options = 8
     Units = ""
     Curve(40956656,"V3a",0,,,)
     Curve(40959432,"V3b",1,,,)
     Curve(40962344,"V3c",2,,,)
     }
    Graph([0,358],[0,0,558,358],"Current")
     {
     Options = 8
     Units = ""
     Curve(40965256,"I3a",0,,,)
     Curve(40968168,"I3b",1,,,)
     Curve(40971080,"I3c",2,,,)
     }
    Graph([0,716],[0,0,558,358],"Current")
     {
     Options = 8
     Units = ""
     Curve(40974072,"I30",0,,,)
     }
    PGraph([0,1074],[0,0,558,339],"PolyGraph")
     {
     Options = 2
     Curve(40994632,"Br3a",0,,,1)
     Curve(40997408,"Br3b",1,,,1)
     Curve(41000184,"Br3c",2,,,1)
     }
    }
   -Plot-([648,36],0)
    {
    Title = "$(GROUP) : Graphs"
    Draw = 1
    Area = [0,0,558,1476]
    Posn = [648,36]
    Icon = [-1,-1]
    Extents = 0,0,558,1476
    XLabel = " "
    AutoPan = "false,75"
    Graph([0,0],[0,0,558,358],"Voltage")
     {
     Options = 0
     Units = ""
     Curve(40833752,"V2a",0,,,)
     Curve(40836664,"V2b",0,,,)
     Curve(40866376,"V2c",0,,,)
     }
    Graph([0,358],[0,0,558,358],"Current")
     {
     Options = 0
     Units = ""
     Curve(40825096,"I2a",0,,,)
     Curve(40827928,"I2b",0,,,)
     Curve(40917808,"I2c",0,,,)
     }
    Graph([0,716],[0,0,558,358],"Current")
     {
     Options = 0
     Units = ""
     Curve(40915032,"I20",0,,,)
     }
    PGraph([0,1074],[0,0,558,339],"PolyGraph")
     {
     Options = 2
     Curve(40846352,"Br2a",0,,,1)
     Curve(40858280,"Br2b",0,,,1)
     Curve(40849048,"Br2c",0,,,1)
     }
    }
   -Plot-([54,36],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,558,1476]
    Posn = [54,36]
    Icon = [-1,-1]
    Extents = 0,0,558,1476
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,558,358],"Voltage")
     {
     Options = 8
     Units = ""
     Curve(41016160,"V1a",0,,,)
     Curve(40852720,"V1b",1,,,)
     Curve(40830840,"V1c",2,,,)
     }
    Graph([0,358],[0,0,558,358],"Current")
     {
     Options = 8
     Units = ""
     Curve(40904560,"I1a",0,,,)
     Curve(40920800,"I1b",1,,,)
     Curve(40907472,"I1c",2,,,)
     }
    Graph([0,716],[0,0,558,358],"Current")
     {
     Options = 8
     Units = ""
     Curve(40911224,"I10",0,,,)
     }
    PGraph([0,1074],[0,0,558,339],"PolyGraph")
     {
     Options = 2
     Curve(40841968,"Br1a",0,,,1)
     Curve(40855504,"Br1b",1,,,1)
     Curve(40893720,"Br1c",2,,,1)
     }
    }
   -Plot-([1836,36],0)
    {
    Title = "Plots at B4"
    Draw = 1
    Area = [0,0,558,1476]
    Posn = [1836,36]
    Icon = [-1,-1]
    Extents = 0,0,558,1476
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,558,358],"Voltage")
     {
     Options = 8
     Units = ""
     Curve(40977040,"V4a",0,,,)
     Curve(40979952,"V4b",1,,,)
     Curve(41125448,"V4c",2,,,)
     }
    Graph([0,358],[0,0,558,358],"Current")
     {
     Options = 8
     Units = ""
     Curve(40983016,"I4a",0,,,)
     Curve(40985872,"I4b",1,,,)
     Curve(40988784,"I4c",2,,,)
     }
    Graph([0,716],[0,0,558,358],"Current")
     {
     Options = 8
     Units = ""
     Curve(40991696,"I40",0,,,)
     }
    PGraph([0,1074],[0,0,558,339],"PolyGraph")
     {
     Options = 2
     Curve(40759008,"Br4a",0,,,1)
     Curve(41008952,"Br4b",1,,,1)
     Curve(41011728,"Br4c",2,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144770087
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.pgb([2088,1206],0,40759008,1090)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([2142,144],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([2178,144],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([2214,144],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([2142,324],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([2178,324],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([2214,324],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1638,1170],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1656,1206],0,0,330)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1656,1242],0,0,400)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2034,144],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([2070,144],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([2106,144],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([2034,324],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([2070,324],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([2106,324],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([2052,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2052,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2052,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2052,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1800,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1800,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1800,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1674,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1674,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1674,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1926,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1926,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1926,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1926,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1926,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1782,1278],0,0,490)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1782,1242],0,0,440)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1782,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1782,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1782,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1656,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1656,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1656,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1656,1278],0,0,470)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1782,1206],0,0,360)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1764,1170],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.var([1908,252],0,40788112,40)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.55"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([450,1152],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([90,1170],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([126,1170],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([162,1170],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([144,1260],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([90,1422],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([126,1422],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([162,1422],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([180,1332],2,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1800,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1674,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([918,648],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([432,540],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([450,648],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([450,666],0,0,-1)
    {
    Name = "F1"
    }
   0.pgb([2214,1278],0,40801240,530)
    {
    Name = "V3rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([2214,1314],0,40804016,540)
    {
    Name = "V4rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([900,450],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([900,468],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([900,684],0,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([900,702],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([486,1152],2,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([414,1152],2,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([234,1170],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([270,1422],0,0,-1)
    {
    Name = "F6"
    }
   0.breaker3([1026,432],0,0,670)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "116.9 [MW]"
    Q = "-18.82 [MVAR]"
    }
   0.datalabel([666,450],0,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([666,468],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([666,684],0,0,-1)
    {
    Name = "FT5"
    }
   -Wire-([648,648],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([612,432],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1980,828],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1980,432],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1980,630],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1188,1332],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([1188,1368],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([1188,1404],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1314,1332],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1314,1368],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1350,1332],0,40825096,970)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1350,1368],0,40827928,900)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1224,1278],0,40830840,390)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "200.0"
    }
   0.pgb([1350,1206],0,40833752,290)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "200.0"
    }
   0.pgb([1350,1242],0,40836664,340)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "200.0"
    }
   0.datalabel([1422,1206],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1422,1242],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1422,1278],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([1458,1206],0,40841968,1140)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.05"
    Max = "0.05"
    }
   0.datalabel([1548,1206],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1548,1242],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1584,1206],0,40846352,1130)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1584,1278],0,40849048,1050)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1422,1332],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([1224,1242],0,40852720,310)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "200.0"
    }
   0.pgb([1458,1242],0,40855504,1120)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.05"
    Max = "0.05"
    }
   0.pgb([1584,1242],0,40858280,1110)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1170,1206],0,0,260)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1170,1242],0,0,300)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1152,1170],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([1188,1206],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([1188,1242],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1314,1242],2,0,-1)
    {
    Name = "V2B"
    }
   0.pgb([1350,1278],0,40866376,430)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "200.0"
    }
   -Wire-([1422,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1422,1404],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1422,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1422,1440],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1548,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1548,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1548,1440],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1314,1206],2,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([1548,1404],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1548,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1548,1368],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1548,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1548,1332],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1548,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1548,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1548,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1548,1278],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1314,1404],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1314,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1314,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1314,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1188,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1188,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1188,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1422,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1422,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1422,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1422,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1422,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1314,1278],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1296,1278],0,0,410)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1296,1242],0,0,320)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1296,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1296,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1296,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1188,1278],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([1170,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1170,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1170,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1170,1278],0,0,380)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1422,1368],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1458,1278],0,40893720,1080)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.05"
    Max = "0.05"
    }
   0.datatap([1296,1206],0,0,280)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1278,1170],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([1278,1170],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1584,1368],0,40898680,860)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1458,1368],0,40901648,890)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1224,1332],0,40904560,980)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "1.5"
    }
   0.pgb([1224,1404],0,40907472,870)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "1.5"
    }
   -Wire-([1314,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1188,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1224,1440],0,40911224,780)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.5"
    Max = "0.3"
    }
   0.datalabel([1314,1440],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1350,1440],0,40915032,760)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.4"
    Max = "0.5"
    }
   0.pgb([1350,1404],0,40917808,830)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.pgb([1224,1368],0,40920800,920)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "1.5"
    }
   -Wire-([1152,1170],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1188,1440],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([1638,1170],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1674,1206],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1674,1242],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1674,1278],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1800,1206],2,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([1800,1242],2,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([1800,1278],2,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([2034,522],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([2070,522],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([2106,522],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([2034,720],6,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([2070,720],6,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([2106,720],6,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1674,1332],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1674,1368],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1674,1404],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1674,1440],0,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([1800,1332],0,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([1800,1368],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([1800,1404],0,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([1800,1440],0,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([2142,522],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([2178,522],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([2214,522],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([2142,720],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([2178,720],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([2214,720],2,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([2214,288],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2214,468],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2214,666],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1926,1332],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([1926,1368],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([1926,1206],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([1926,1242],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([1926,1278],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([2052,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2052,1206],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([2052,1242],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([2052,1278],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([2052,1332],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([2052,1368],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([1710,1206],0,40956656,350)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1710,1242],0,40959432,420)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1710,1278],0,40962344,480)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1710,1332],0,40965256,910)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1710,1368],0,40968168,840)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1710,1404],0,40971080,750)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.pgb([1710,1440],0,40974072,700)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "3.0"
    }
   0.pgb([1836,1206],0,40977040,370)
    {
    Name = "V4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1836,1242],0,40979952,450)
    {
    Name = "V4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1836,1332],0,40983016,880)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1836,1368],0,40985872,800)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1836,1404],0,40988784,720)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1836,1440],0,40991696,690)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "0.6"
    }
   0.pgb([1962,1206],0,40994632,1100)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1962,1242],0,40997408,1030)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1962,1278],0,41000184,960)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1962,1368],0,41003128,770)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2088,1368],0,41006040,740)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2088,1242],0,41008952,990)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2088,1278],0,41011728,940)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([666,702],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([522,1152],2,0,-1)
    {
    Name = "B4"
    }
   0.pgb([1224,1206],0,41016160,270)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "200.0"
    }
   0.pgb([2214,1206],0,41021016,460)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([954,432],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.pgb([2214,1242],0,41023160,510)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([504,540],0,0,-1)
    {
    Vertex="0,0;-144,0"
    }
   -Wire-([1062,540],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datalabel([1098,666],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([1098,648],0,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([1116,540],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1458,1332],0,41029144,950)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   -Wire-([1980,252],0,0,-1)
    {
    Vertex="0,0;0,576"
    }
   0.datalabel([1332,900],4,0,-1)
    {
    Name = "Breaker"
    }
   0.datalabel([378,1170],0,0,-1)
    {
    Name = "Breaker"
    }
   0.var_pot([72,1296],0,41034088,230)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "6"
    Value = "5"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([144,1296],0,0,240)
    {
    IType = "2"
    OType = "1"
    }
   0.mux_array([162,1368],6,0,600)
    {
    DPath = "0"
    }
   -Wire-([504,1170],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   0.datatap([414,1152],6,0,640)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([450,1152],6,0,630)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([486,1152],6,0,620)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([522,1152],6,0,610)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([90,1170],6,0,1210)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([126,1170],6,0,1200)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([162,1170],6,0,1190)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([198,1170],6,0,1180)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([234,1170],6,0,1170)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([270,1170],6,0,1160)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([198,1170],2,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([252,1188],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datatap([90,1422],0,0,1070)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([126,1422],0,0,1060)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([162,1422],0,0,1040)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([198,1422],0,0,1020)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([234,1422],0,0,1010)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([270,1422],0,0,1000)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([270,1170],2,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([234,1422],0,0,-1)
    {
    Name = "F5"
    }
   -Wire-([252,1404],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datalabel([198,1422],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([1332,918],4,0,-1)
    {
    Name = "Faulttype"
    }
   0.var_pot([252,1296],2,41061696,250)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "1"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.unity([180,1296],4,0,580)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([180,1296],1,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([180,1260],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.pgb([1962,1332],0,41066912,850)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.var([288,612],3,41069824,100)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([342,612],3,41072680,110)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1242,612],5,41075536,160)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1188,612],5,41078392,140)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   -Sticky-([270,414],0)
    {
    Name = ""
    Font = 1
    Bounds = 270,414,360,450
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   0.source3R([324,540],6,0,560)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.source3R([1206,540],2,0,570)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   -Wire-([144,1476],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([216,1476],0,0,-1)
    {
    Name = "Ron"
    }
   0.tpflt([630,666],0,0,1260)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1134,630],4,0,1250)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([414,630],0,0,1270)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.breaker3([540,432],4,0,680)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-114.9 [MW]"
    Q = "14.86 [MVAR]"
    }
   0.datalabel([1764,1170],2,0,-1)
    {
    Name = "V4"
    }
   0.tpflt([936,666],4,0,1240)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([630,432],0,0,1300)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([2214,864],0,0,-1)
    {
    Name = "Fault"
    }
   0.annotation([108,1458],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.pgb([1458,1404],0,41100648,810)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1458,1440],0,41103648,730)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1584,1404],0,41106560,790)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1584,1440],0,41109472,710)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.tpflt([936,432],4,0,1290)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Bus-([504,414],0,31143936,-1)
    {
    P1 = [0,0]
    P2 = [0,252]
    I = 1
    NAME = BUS1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   -Bus-([1062,396],0,43025208,-1)
    {
    P1 = [0,0]
    P2 = [0,288]
    I = 1
    NAME = BUS2
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.breaker3([540,648],4,0,660)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0.05166 [MW]"
    Q = "0.009162 [MVAR]"
    }
   0.breaker3([1026,648],0,0,650)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0.05819 [MW]"
    Q = "0.05598 [MVAR]"
    }
   0.pgb([2088,1332],0,41122512,820)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([1836,1278],0,41125448,500)
    {
    Name = "V4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1584,1332],0,41128528,930)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   -Sticky-([576,1134],0)
    {
    Name = ""
    Font = 1
    Bounds = 576,1134,684,1170
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.mux_array([162,1224],0,0,1150)
    {
    DPath = "0"
    }
   0.var([108,1476],0,41132808,520)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = ".001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   0.const([1746,180],1,0,20)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([1782,216],6,0,550)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([1746,360],1,0,80)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([1782,396],6,0,90)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([1764,558],1,0,150)
    {
    Name = ""
    Value = "10.0"
    }
   0.const([1764,756],1,0,200)
    {
    Name = ""
    Value = "10.0"
    }
   0.var([1674,252],0,41140592,30)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   -Wire-([1710,252],0,0,-1)
    {
    Vertex="0,0;0,576"
    }
   -Wire-([1710,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1710,252],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1818,396],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   -Wire-([1818,216],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   0.select([1800,594],6,0,180)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([1836,594],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   -Wire-([1944,252],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1710,630],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1710,828],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.select([1800,792],6,0,210)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([1836,792],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   0.var_switch([1782,144],1,41149808,10)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1782,324],1,41152528,60)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1800,522],1,41155248,120)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1800,720],1,41157968,190)
    {
    Name = "en Record4"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([1332,954],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1386,954],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([1332,918],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1386,900],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -TLine-([666,432],0,43197496,-1)
    {
    Name = "LINE1"
    Date = 1144770088
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,43199640,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([522,198],0,33434808,-1)
      {
      Mode = "0"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_FrePhase_Options([216,468],0,33435856,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.Line_Tower_3_Delta([810,612],0,33436328,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -TLine-([666,648],0,43234384,-1)
    {
    Name = "LINE2"
    Date = 1144770088
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,43235848,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([522,198],0,43236752,-1)
      {
      Mode = "1"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_FrePhase_Options([216,468],0,43271296,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.Line_Tower_3_Delta([810,612],0,43271784,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "C:\\home\\user\\pscad\\lineconstants\\database\\gw.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -Wire-([954,648],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([612,648],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Sticky-([1134,432],0)
    {
    Name = ""
    Font = 1
    Bounds = 1134,432,1224,468
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   .Plots([1512,936],0,0,220)
    {
    }
   -Sticky-([36,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 36,36,576,198
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Description: 
- Two Thevinen Impedance sources connected via 
   two parallel 100km transmission lines.
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via two transmission lines.
- Six fault positions for full fault control ahead and behind station relays.
- Four breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible."
    }
   .Controls([1422,936],4,0,590)
    {
    }
   0.recorder2_0([2106,792],0,0,1220)
    {
    FName = "stn4"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "4"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "2"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "2"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "2"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = ".4"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = ".4"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = ".4"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([2106,396],0,0,1280)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "2"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "2"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "2"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = ".4"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = ".4"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = ".4"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([2106,216],0,0,1310)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "2"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "2"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "2"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = ".4"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = ".4"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = ".4"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([2106,594],0,0,1230)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "2"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "2"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "2"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = ".4"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = ".4"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = ".4"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   -Sticky-([630,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 630,36,1026,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   0.multimeter([594,432],0,0,50)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([972,432],4,0,70)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([594,648],0,0,130)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V3"
    P = ""
    Q = ""
    Vrms = "V3rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([972,648],4,0,170)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V4"
    P = ""
    Q = ""
    Vrms = "V4rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Divider-([1584,18],1)
    {
    Size(0,1008)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([36,1026],0)
    {
    Size(1548,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Wire-([2178,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2178,1206],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([2178,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2178,1242],0,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([2178,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2178,1278],0,0,-1)
    {
    Name = "V3rms"
    }
   -Wire-([2178,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2178,1314],0,0,-1)
    {
    Name = "V4rms"
    }
   }
  }
 }

